/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.platform;

import com.google.inject.Inject;
import com.google.inject.Provider;
import info.msxlaunchers.openmsx.common.OSUtils;
import info.msxlaunchers.platform.ArgumentsBuilderProvider;
import info.msxlaunchers.platform.FileLocator;
import info.msxlaunchers.platform.LinuxBSDFileLocator;
import info.msxlaunchers.platform.MacFileLocator;
import info.msxlaunchers.platform.WindowsFileLocator;

final class FileLocatorProvider
implements Provider<FileLocator> {
    private final ArgumentsBuilderProvider argumentsBuilderProvider;

    @Inject
    FileLocatorProvider(ArgumentsBuilderProvider argumentsBuilderProvider) {
        this.argumentsBuilderProvider = argumentsBuilderProvider;
    }

    public FileLocator get() {
        if (OSUtils.isWindows()) {
            return new WindowsFileLocator(this.argumentsBuilderProvider.get());
        }
        if (OSUtils.isMac()) {
            return new MacFileLocator(this.argumentsBuilderProvider.get());
        }
        if (OSUtils.isLinux() || OSUtils.isBSD()) {
            return new LinuxBSDFileLocator(this.argumentsBuilderProvider.get());
        }
        throw new IllegalArgumentException("Unsupported Operating System");
    }
}

